/*
 * Decompiled with CFR 0.152.
 */
package com.thecodecollective.netbeans.completion;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompletionAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow activeWindow = null;
    private static final String COMPLETION_PLUGIN = "com.thecodecollective.netbeans.completion";
    private static Plugin plugin = null;
    private CompletionState lastCompletion = null;
    private LinkedList completionHistory;

    private static void log(String message, Throwable exception) {
        if (plugin == null) {
            plugin = Platform.getPlugin((String)COMPLETION_PLUGIN);
        }
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, COMPLETION_PLUGIN, 0, message, exception));
        }
    }

    private static void log(String message) {
        CompletionAction.log(message, null);
    }

    private static void getSuggestions(String document, String prefix, Vector results, int startIndex) {
        CompletionAction.log("start index is " + startIndex);
        int index = 0;
        while ((index = document.indexOf(prefix, index)) != -1) {
            int firstChar;
            if (index != 0 && Character.isJavaIdentifierPart(document.charAt(index - 1))) {
                index += prefix.length();
                continue;
            }
            int lastChar = firstChar = index + prefix.length();
            while (lastChar < document.length() && Character.isJavaIdentifierPart(document.charAt(lastChar))) {
                ++lastChar;
            }
            if (lastChar != firstChar) {
                String addition = document.substring(firstChar, lastChar);
                if (index < startIndex) {
                    results.remove(addition);
                    results.add(0, addition);
                    CompletionAction.log(String.valueOf(index) + " added first " + results);
                } else if (!results.contains(addition)) {
                    results.add(addition);
                    CompletionAction.log(String.valueOf(index) + " added last " + results);
                }
            }
            index = lastChar;
        }
    }

    private static void scrubHistory(LinkedList history) {
        try {
            String firstElement = (String)history.getFirst();
            history.subList(1, history.size()).remove(firstElement);
            if (history.size() > 100) {
                ListIterator iter = history.listIterator(100);
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
            }
        }
        catch (NoSuchElementException e) {
            return;
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    private static Vector considerLatestCompletions(List latest, List current, String prefix) {
        String s;
        int prefixLength = prefix.length();
        HashSet<String> currentSuggestionsSet = new HashSet<String>();
        Iterator iter = current.iterator();
        while (iter.hasNext()) {
            String s2 = (String)iter.next();
            currentSuggestionsSet.add(String.valueOf(prefix) + s2);
        }
        Vector<String> prioritizedList = new Vector<String>(current.size());
        Iterator iter2 = latest.iterator();
        while (iter2.hasNext()) {
            s = (String)iter2.next();
            if (!currentSuggestionsSet.contains(s)) continue;
            currentSuggestionsSet.remove(s);
            prioritizedList.add(s.substring(prefixLength));
        }
        iter2 = current.iterator();
        while (iter2.hasNext()) {
            s = (String)iter2.next();
            s = String.valueOf(prefix) + s;
            if (!currentSuggestionsSet.contains(s)) continue;
            currentSuggestionsSet.remove(s);
            prioritizedList.add(s.substring(prefixLength));
        }
        return prioritizedList;
    }

    public String[] getSuggestions(String prefix) {
        IEditorReference[] editorsArray = this.activeWindow.getActivePage().getEditorReferences();
        Vector<IEditorPart> editorsVector = new Vector<IEditorPart>();
        int i = 0;
        while (i < editorsArray.length) {
            IEditorPart realEditor = editorsArray[i].getEditor(false);
            if (realEditor != null) {
                editorsVector.add(realEditor);
            }
            ++i;
        }
        editorsVector.remove(this.activeWindow.getActivePage().getActiveEditor());
        editorsVector.add(0, this.activeWindow.getActivePage().getActiveEditor());
        Vector<String> suggestions = new Vector<String>();
        int i2 = 0;
        while (i2 < editorsVector.size()) {
            if (editorsVector.get(i2) instanceof AbstractTextEditor) {
                AbstractTextEditor textEditor = (AbstractTextEditor)editorsVector.get(i2);
                IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int startIndex = 0;
                if (i2 == 0) {
                    ITextSelection textSelection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
                    startIndex = textSelection.getOffset();
                }
                CompletionAction.getSuggestions(doc.get(), prefix, suggestions, startIndex);
                CompletionAction.log(String.valueOf(textEditor.getTitle()) + ": " + suggestions);
            }
            ++i2;
        }
        CompletionAction.scrubHistory(this.completionHistory);
        suggestions.add("");
        return suggestions.toArray(new String[0]);
    }

    public String getCurrentPrefix(ITextEditor textEditor) {
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        if (selection.getLength() > 0) {
            return null;
        }
        int pos = selection.getOffset();
        String docText = doc.get();
        int prevNonAlpha = pos;
        while (prevNonAlpha > 0 && Character.isJavaIdentifierPart(docText.charAt(prevNonAlpha - 1))) {
            --prevNonAlpha;
        }
        if (prevNonAlpha != pos) {
            return docText.substring(prevNonAlpha, pos);
        }
        return null;
    }

    public void run(IAction proxyAction) {
        IEditorPart editor = this.activeWindow.getActivePage().getActiveEditor();
        if (this.lastCompletion != null && this.lastCompletion.isValid() && editor == this.lastCompletion.getParentEditor()) {
            this.lastCompletion.next();
        } else {
            if (this.lastCompletion != null) {
                this.lastCompletion.removeListener();
            }
            if (!(editor instanceof ITextEditor)) {
                this.activeWindow.getShell().getDisplay().beep();
                return;
            }
            ITextEditor textEditor = (ITextEditor)editor;
            String prefix = this.getCurrentPrefix(textEditor);
            if (prefix == null) {
                this.activeWindow.getShell().getDisplay().beep();
                return;
            }
            String[] suggestions = this.getSuggestions(prefix);
            if (suggestions.length == 1) {
                this.activeWindow.getShell().getDisplay().beep();
                return;
            }
            this.lastCompletion = new CompletionState(textEditor, prefix, suggestions, ((ITextSelection)textEditor.getSelectionProvider().getSelection()).getOffset());
            this.lastCompletion.next();
        }
    }

    public void selectionChanged(IAction proxyAction, ISelection selection) {
        if (selection instanceof TextSelection) {
            proxyAction.setEnabled(true);
            return;
        }
        proxyAction.setEnabled(!selection.isEmpty() && this.activeWindow.getActivePage().getActivePart() instanceof ITextEditor);
        if (this.lastCompletion != null) {
            this.lastCompletion.removeListener();
        }
        this.lastCompletion = null;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.activeWindow = window;
        this.completionHistory = new LinkedList();
    }

    private class CompletionState
    implements IDocumentListener {
        final ITextEditor parentEditor;
        final String[] suggestions;
        final String prefix;
        final int startOffset;
        int nextSuggestion;
        int length;
        boolean valid = true;

        CompletionState(ITextEditor parent, String prefix, String[] suggestions, int startOffset) {
            this.parentEditor = parent;
            this.suggestions = suggestions;
            this.startOffset = startOffset;
            this.prefix = prefix;
            this.length = 0;
            this.nextSuggestion = 0;
            CompletionAction.this.completionHistory.addFirst(null);
        }

        public void next() {
            IDocumentProvider provider = this.parentEditor.getDocumentProvider();
            IEditorInput input = this.parentEditor.getEditorInput();
            IDocument doc = provider.getDocument((Object)input);
            doc.removeDocumentListener((IDocumentListener)this);
            try {
                doc.replace(this.startOffset, this.length, this.suggestions[this.nextSuggestion]);
            }
            catch (BadLocationException e) {
                throw new IllegalStateException(e.toString());
            }
            this.updateCompletionHistory(String.valueOf(this.prefix) + this.suggestions[this.nextSuggestion]);
            this.length = this.suggestions[this.nextSuggestion].length();
            this.parentEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(this.startOffset + this.length, 0));
            this.nextSuggestion = (this.nextSuggestion + 1) % this.suggestions.length;
            doc.addDocumentListener((IDocumentListener)this);
        }

        public void updateCompletionHistory(String accepted) {
            CompletionAction.this.completionHistory.set(0, accepted);
        }

        public ITextEditor getParentEditor() {
            return this.parentEditor;
        }

        public boolean isValid() {
            if (!this.valid) {
                return false;
            }
            IDocumentProvider provider = this.parentEditor.getDocumentProvider();
            IEditorInput input = this.parentEditor.getEditorInput();
            ISelectionProvider selProvider = this.parentEditor.getSelectionProvider();
            ITextSelection sel = (ITextSelection)selProvider.getSelection();
            return sel.getOffset() == this.startOffset + this.length;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.valid = false;
            event.getDocument().removeDocumentListener((IDocumentListener)this);
        }

        public void removeListener() {
            IDocumentProvider provider = this.parentEditor.getDocumentProvider();
            IEditorInput input = this.parentEditor.getEditorInput();
            IDocument doc = provider.getDocument((Object)input);
            doc.removeDocumentListener((IDocumentListener)this);
        }
    }
}

