package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.texteditor.ITextEditor;

public class RectangularEditAction extends AbstractAction {

  public RectangularEditAction() {
    super();
  }

  public void run(IAction action) {
    ITextEditor textEditor = getTextEditor();
    if (textEditor == null) {
      beep();
      return;
    }
    IDocument doc = textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
    ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
    if (selection.isEmpty()) {
      beep();
      return;
    }
    
    IRegion startLine = null;
    IRegion endLine = null;
    try {
      startLine = doc.getLineInformation(selection.getStartLine());
      endLine = doc.getLineInformation(selection.getEndLine());
    } catch (BadLocationException e) {
      beep();
      return;
    }
    // the length of the not-selected prefix in every line:
    int prefixLen = selection.getOffset() - startLine.getOffset();
    // length of the selection in the last line of the selection:
    int lenInEndLine = selection.getLength() - endLine.getOffset() + selection.getOffset();
    // the width of the selected rectangle:
    int rectLen = lenInEndLine - prefixLen;
    if (rectLen < 0) {
      beep();
      return;
    }
    
    InputDialog dialog = new InputDialog(m_window.getShell(),
                                         "Rectangular Edit",
                                         "Enter the replacement text:",
                                         null, null);
    if (dialog.open() != Window.OK) {
      return;
    }
    String repl = dialog.getValue();
    StringBuffer sb = new StringBuffer();
    try {
      int cursorPos = -1;
      for (int i=selection.getStartLine(); i<=selection.getEndLine(); i++) {
        IRegion line = doc.getLineInformation(i);
        sb.append(doc.get(line.getOffset(), prefixLen)); // the prefix in every line
        sb.append(repl);
        int postfixPos = line.getOffset() + prefixLen + rectLen;
        int postfixLen = line.getLength() - postfixPos + line.getOffset();
        sb.append(doc.get(postfixPos, postfixLen)); // the postfix
        if (i != selection.getEndLine()) {
          sb.append(doc.getLineDelimiter(i));
        } else {
          cursorPos = selection.getOffset() + sb.length() 
                      - prefixLen - postfixLen;
        }
      }
      doc.replace(startLine.getOffset(), 
                  endLine.getOffset() + endLine.getLength() - startLine.getOffset(),
                  sb.toString());
      setCaretPosition(cursorPos);
    } catch(BadLocationException e) {
      beep();
      // e.printStackTrace();
      return; 
    }
  }

}
