package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;


public class Pos1Action extends AbstractAction {
  
  /**
   * The action has been activated. The argument of the
   * method represents the 'real' action sitting
   * in the workbench UI.
   * @see IWorkbenchWindowActionDelegate#run
   */
  public void run(IAction action) {
    ITextEditor textEditor = getTextEditor();
    if (textEditor == null) {
      beep();
      return;
    }
    IDocument doc = textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
    ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
    gotoFirstVisibleChar(doc, selection.getOffset());
  }
}