package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class KillLineAction extends AbstractAction {

  public KillLineAction() {
    super();
  }

  public void run(IAction action) {
    ITextEditor textEditor = getTextEditor();
    if (textEditor == null) {
      beep();
      return;
    }
    IDocument doc = textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
    ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
    try {
      int cursorPos = selection.getOffset();
      int linePos = doc.getLineOfOffset(cursorPos);
      IRegion line = doc.getLineInformation(linePos);
      String delim = doc.getLineDelimiter(linePos);
      int i=0;
      if (delim != null) {
        i = delim.length();
      }
      doc.replace(line.getOffset(), line.getLength()+i, "");
      gotoFirstVisibleChar(doc, cursorPos); 
    } catch(BadLocationException e) {
      beep();
      return;
    }
  }

}
