package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertLineAction extends AbstractAction {

  public InsertLineAction() {
    super();
  }

  public void run(IAction action) {
    ITextEditor textEditor = getTextEditor();
    if (textEditor == null) {
      beep();
      return;
    }
    IDocument doc = textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
    ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
    IRegion line = null;
    StringBuffer sb = new StringBuffer();
    try {
      int pos = selection.getOffset();
      int lpos = doc.getLineOfOffset(pos);
      line = doc.getLineInformation(lpos);
      String text = doc.get(line.getOffset(), line.getLength());
      sb.append(text);
      String delim = doc.getLineDelimiter(lpos);
      if (delim == null) {
        delim = doc.getLegalLineDelimiters()[0];
      }
      sb.append(delim);
      int i;
      for (i = 0; i < text.length(); i++) {
        char c = text.charAt(i);
        if (Character.isWhitespace(c)) {
          sb.append(c);
        } else {
          break;
        } 
      }
      doc.replace(line.getOffset(), line.getLength(), sb.toString());
      setCaretPosition(line.getOffset() + sb.length());
    } catch (BadLocationException e) {
      beep();
      return;
    }
  }

}
