package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class CopyLineAction extends AbstractAction {

  public CopyLineAction() {
    super();
  }

  public void run(IAction action) {
    ITextEditor textEditor = getTextEditor();
    if (textEditor == null) {
      beep();
      return;
    }
    IDocument doc = textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
    ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
    if (selection.getStartLine() != selection.getEndLine()) {
      beep();
      return;
    }
    try {
      int pos = selection.getOffset();
      IRegion line = doc.getLineInformationOfOffset(pos);
      String text = doc.get(line.getOffset(), line.getLength());
      text = text.trim();
      Clipboard c = new Clipboard(m_window.getShell().getDisplay());
      c.setContents(new String[]{text}, 
                    new Transfer[]{TextTransfer.getInstance()});     
    } catch(BadLocationException e) {
      beep();
      return;
    }
    
  }

}
