package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractAction implements IWorkbenchWindowActionDelegate {

  protected IWorkbenchWindow m_window;
  
  public AbstractAction() {
    super();
  }

  /**
   * We can use this method to dispose of any system
   * resources we previously allocated.
   * @see IWorkbenchWindowActionDelegate#dispose
   */
  public void dispose() {
  }

  /**
   * We will cache window object in order to
   * be able to provide parent shell for the message dialog.
   * @see IWorkbenchWindowActionDelegate#init
   */
  public void init(IWorkbenchWindow window) {
    m_window = window;
    
  }
   
  /**
   * Selection in the workbench has been changed. We 
   * can change the state of the 'real' action here
   * if we want, but this can only happen after 
   * the delegate has been created.
   * @see IWorkbenchWindowActionDelegate#selectionChanged
   */
  public void selectionChanged(IAction action, ISelection selection) {
    if (selection instanceof TextSelection) {
      action.setEnabled(true);
      return;
    }
    action.setEnabled(m_window.getActivePage().getActivePart() instanceof ITextEditor);
  }

  /**
   * The action has been activated. The argument of the
   * method represents the 'real' action sitting
   * in the workbench UI.
   * @see IWorkbenchWindowActionDelegate#run
   */
  public abstract void run(IAction action);
      
  protected void beep() {
    m_window.getShell().getDisplay().beep();
  }

  protected ITextEditor getTextEditor() {
    IEditorPart editor = m_window.getActivePage().getActiveEditor();
    ITextEditor textEditor;
    if (editor instanceof ITextEditor) {
      return (ITextEditor)editor;
    } else {
      return null;
    } 
  }
  
  protected void setCaretPosition(int pos) throws BadLocationException {
    ITextEditor e = getTextEditor();
    if (e != null) {
      e.selectAndReveal(pos,0);  
    }
  }
  
  protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
    try {
      IRegion region = doc.getLineInformationOfOffset(cursorOffset);
      int offset = region.getOffset();
      String src = doc.get(offset, region.getLength());
      if ("".equals(src)) return;
      int i = 0;
      while(i < src.length()) {
        if (!Character.isWhitespace(src.charAt(i++))) {
          break;
        }
      }
      setCaretPosition(offset+i-1);
    } catch (BadLocationException e) {
      beep();
      return;
    }    
  }
}
