/*
 * Decompiled with CFR 0.152.
 */
package net.stefanheimann.editorEnhancements.actions;

import net.stefanheimann.editorEnhancements.actions.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class RectangularEditAction
extends AbstractAction {
    public void run(IAction action) {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            this.beep();
            return;
        }
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            this.beep();
            return;
        }
        IRegion startLine = null;
        IRegion endLine = null;
        try {
            startLine = doc.getLineInformation(selection.getStartLine());
            endLine = doc.getLineInformation(selection.getEndLine());
        }
        catch (BadLocationException badLocationException) {
            this.beep();
            return;
        }
        int prefixLen = selection.getOffset() - startLine.getOffset();
        int lenInEndLine = selection.getLength() - endLine.getOffset() + selection.getOffset();
        int rectLen = lenInEndLine - prefixLen;
        if (rectLen < 0) {
            this.beep();
            return;
        }
        InputDialog dialog = new InputDialog(this.m_window.getShell(), "Rectangular Edit", "Enter the replacement text:", null, null);
        if (dialog.open() != 0) {
            return;
        }
        String repl = dialog.getValue();
        StringBuffer sb = new StringBuffer();
        try {
            int cursorPos = -1;
            int i = selection.getStartLine();
            while (i <= selection.getEndLine()) {
                IRegion line = doc.getLineInformation(i);
                sb.append(doc.get(line.getOffset(), prefixLen));
                sb.append(repl);
                int postfixPos = line.getOffset() + prefixLen + rectLen;
                int postfixLen = line.getLength() - postfixPos + line.getOffset();
                sb.append(doc.get(postfixPos, postfixLen));
                if (i != selection.getEndLine()) {
                    sb.append(doc.getLineDelimiter(i));
                } else {
                    cursorPos = selection.getOffset() + sb.length() - prefixLen - postfixLen;
                }
                ++i;
            }
            doc.replace(startLine.getOffset(), endLine.getOffset() + endLine.getLength() - startLine.getOffset(), sb.toString());
            this.setCaretPosition(cursorPos);
        }
        catch (BadLocationException badLocationException) {
            this.beep();
            return;
        }
    }
}

