/*
 * Decompiled with CFR 0.152.
 */
package net.stefanheimann.editorEnhancements.actions;

import net.stefanheimann.editorEnhancements.actions.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertLineAction
extends AbstractAction {
    public void run(IAction action) {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            this.beep();
            return;
        }
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        IRegion line = null;
        StringBuffer sb = new StringBuffer();
        try {
            int pos = selection.getOffset();
            int lpos = doc.getLineOfOffset(pos);
            line = doc.getLineInformation(lpos);
            String text = doc.get(line.getOffset(), line.getLength());
            sb.append(text);
            String delim = doc.getLineDelimiter(lpos);
            if (delim == null) {
                delim = doc.getLegalLineDelimiters()[0];
            }
            sb.append(delim);
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) break;
                sb.append(c);
                ++i;
            }
            doc.replace(line.getOffset(), line.getLength(), sb.toString());
            this.setCaretPosition(line.getOffset() + sb.length());
        }
        catch (BadLocationException badLocationException) {
            this.beep();
            return;
        }
    }
}

