/*
 * Decompiled with CFR 0.152.
 */
package net.stefanheimann.editorEnhancements.actions;

import net.stefanheimann.editorEnhancements.actions.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class CopyLineAction
extends AbstractAction {
    public void run(IAction action) {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            this.beep();
            return;
        }
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        if (selection.getStartLine() != selection.getEndLine()) {
            this.beep();
            return;
        }
        try {
            int pos = selection.getOffset();
            IRegion line = doc.getLineInformationOfOffset(pos);
            String text = doc.get(line.getOffset(), line.getLength());
            text = text.trim();
            Clipboard c = new Clipboard(this.m_window.getShell().getDisplay());
            c.setContents((Object[])new String[]{text}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (BadLocationException badLocationException) {
            this.beep();
            return;
        }
    }
}

