/*
 * Decompiled with CFR 0.152.
 */
package net.stefanheimann.editorEnhancements.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractAction
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow m_window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.m_window.getActivePage().getActivePart() instanceof ITextEditor);
    }

    public abstract void run(IAction var1);

    protected void beep() {
        this.m_window.getShell().getDisplay().beep();
    }

    protected ITextEditor getTextEditor() {
        IEditorPart editor = this.m_window.getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    protected void setCaretPosition(int pos) throws BadLocationException {
        ITextEditor e = this.getTextEditor();
        if (e != null) {
            e.selectAndReveal(pos, 0);
        }
    }

    protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            String src = doc.get(offset, region.getLength());
            if ("".equals(src)) {
                return;
            }
            int i = 0;
            while (i < src.length()) {
                if (!Character.isWhitespace(src.charAt(i++))) break;
            }
            this.setCaretPosition(offset + i - 1);
        }
        catch (BadLocationException badLocationException) {
            this.beep();
            return;
        }
    }
}

